/***************************************************************************
 *            errorcalc.h
 *
 *  Copyright (c) 2003 Lukasz Tomicki <tomicki@o2.pl> www.tomicki.net
 *  
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __ERROR_CALC_H
#define __ERROR_CALC_H

#include <stdio.h>
#include <cmath>
#include <list>

typedef unsigned int UINT;

class CErrorCalc  
{
public:
	class ErrorCalcOptions
	{
	public:
		ErrorCalcOptions() : discard(true) { };
		
		bool discard;
	};	

	// prints all computed values
	void PrintVerboseInfo();

	// used to set class options
	// the one and only argument is a ErrorCalcOptions struct 
	// filled with the options to set
	void SetOptions(ErrorCalcOptions options);

	// calling eval() is optional
	// when eval() is called, all calculations are performed
	// otherwise they are performed when needed
	void eval();

	// returns the number of discarded values, range - (Xavr - Xdmax, Xavr + Xdmax)
	// Xdmax = (Xmax - Xmin) / 2
	UINT getDiscarded();
	
	// returns the total number of values - n
	UINT getTotal();

	// returns the average - (X1 + Xn) / n
	float getAverage();

	// returns the delta average (|Xavr - X1| + |Xavr - Xn|) / n
	float getErrorDelta();

	// returns the std error - square root ((sqr(Xavr - X1) + sqr(Xavr - Xn)) / n)
	// 2/3 of values are located within (Xavr - Xstd, Xavr + Xstd)
	float getErrorStd();

	// initialize the object with a string
	CErrorCalc(float **, UINT);
	CErrorCalc(const char *file);

	// or with a valid file handle
	CErrorCalc(FILE *hFile);
	~CErrorCalc();

	// support function
	static float MakeUnsigned(float input);

private:
	void CountDeltaSqr();
	void CountDeltaAverage();
	void CountAvg();
	void RemoveValuesOutOfRange();
	void ReadData(const char *file);
	void ReadData(FILE *hFile);
	void CleanUp();
	
	std::list<float*> *data;

	UINT discarded;
	UINT values;
	ErrorCalcOptions options;
	bool _average;
	bool _delta;
	bool _std;
	float average;
	float deltaError;
	float stdError;
};

#endif // __ERROR_CALC_H
