/***************************************************************************
 *  CBrutePasswd.h : This file is part of 'chimera'
 *
 *  (c) 2003,2004 by Lukasz Tomicki <tomicki@o2.pl>
 *	Documentation @ http://tomicki.net/
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __BRUTE_PASSWD_H_
#define __BRUTE_PASSWD_H_

#include <string.h>
#include <cmath>
#include <stdio.h>
#include "misc.h"

typedef unsigned int uint;

class CBrutePasswd {
public:
	static const uint buffer_size = 31;
	static const uint passwd_max_size = 1;
	static const uint passwd_min_size = 1;
	
public:
	CBrutePasswd();
	CBrutePasswd(const char *);
	 ~CBrutePasswd();

	void rewindPasswds(uint, uint);
	const char *getNextPasswd();
	void setCharset(const char *);
	int findCharPos(char);
	double getPasswdNum(uint = 0);

protected:
	void freeCharset();

private:
	void setMinLength(uint);
	void setMaxLength(uint);

	char buffer[buffer_size + 1];
	uint m_max_length;
	uint m_min_length;
	int m_pos;
	uint m_next;
	uint m_size;
	uint m_charset_size;
	char *m_charset;
};

template < class tName > tName min(tName & a, tName & b) {
	return (a > b ? b : a);
}

template < class tName > tName max(tName & a, tName & b) {
	return (a > b ? a : b);
}

#endif // __BRUTE_PASSWD_H_
