/***************************************************************************
 *  chimera.cc : This file is part of 'chimera'
 *
 *  (c) 2003,2004 by Lukasz Tomicki <tomicki@o2.pl>
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "chimera.h"

using namespace std;

FILE *hFile = 0;
const char *passwd = 0;
CServiceAttack *crack = 0;

const char* get_single_passwd(bool r)
{
	static bool t(true);
	
	if (r) {
		t = true;
		return 0;
	}
	
	if (t) {
		t = false;
		return ( passwd );
	} else
		return 0;
}

const char* get_passwd(bool r)
{
	if (r) {
		rewind(hFile);
		return 0;
	}
	
	char *p = CServiceAttack::get_next_line(hFile);
	
	if (!p)
		rewind(hFile);
	
	return ( p );
}

void print_data(const char *p)
{
	printf(p);
}

void deal_with_results(CServiceAttack::target_output_data *p)
{
		printf("service: ");
		switch (p->type) {
			case CServiceAttack::SERVICE_POP3:
				printf("pop3");
			break;
			
			case CServiceAttack::SERVICE_FTP:
				printf("ftp");
			break;
			
			case CServiceAttack::SERVICE_GG:
				printf("gg");
			break;
			
			case CServiceAttack::SERVICE_VNC:
				printf("vnc");
			break;
			
			case CServiceAttack::SERVICE_MYSQL:
				printf("mysql");
			break;
		}
		printf(" host: %s port: %d user: %s password: %s\n", 
			inet_ntoa(p->addr.sin_addr), ntohs(p->addr.sin_port), p->user, 
			p->passwd ? p->passwd : "null");
		fflush(stdout);
	
	delete p;
}

bool parse_command_line_args(CServiceAttack *p, int argc, char **argv)
{
	CServiceAttack::target_input_data target_host;
	char *host = 0;
	char *host_file = 0;
	char *user_file = 0;
	u16 port(0);
	uint mlevel(CServiceAttack::MSG_BASIC);
	
	char o;
	while ((o = getopt(argc, argv, "s:u:U:p:P:c:C:m:M:h:H:e:lvt:T:nyrab:")) != -1) {
		switch (o) {
			case 'b':
				p->set_thread_creation_speed(atoi(optarg));
			break;
			
			case 'a':
				p->set_thread_reduction(false);
			break;
			
			case 's':
				if (!strcmp(optarg, "pop3"))
					target_host.type = CServiceAttack::SERVICE_POP3;
				
				else if (!strcmp(optarg, "ftp"))
					target_host.type = CServiceAttack::SERVICE_FTP;
				
				else if (!strcmp(optarg, "vnc"))
					target_host.type = CServiceAttack::SERVICE_VNC;
				
				else if (!strcmp(optarg, "mysql"))
					target_host.type = CServiceAttack::SERVICE_MYSQL;
			break;
				
			case 'u':
				target_host.user = alloc_copy(optarg);
			break;
			
			case 'U':
				user_file = alloc_copy(optarg);
			break;
			
			case 'p':
				passwd = alloc_copy(optarg);
			break;
			
			case 'P':
				if (!strcmp(optarg, "stdin"))
					hFile = stdin;
				else
					hFile = fopen(optarg, "r");
			break;
			
			case 'c':
				switch (optarg[0]) {
					case '1':
						target_host.charset = "abcdefghijklmnopqrstuvwyxz";
					break;
					
					case '2':
						target_host.charset = "abcdefghijklmnopqrstuvwyxzABCDEFGHIJKLMNOPQRSTUVWYXZ";
					break;
					
					case '3':
						target_host.charset = "abcdefghijklmnopqrstuvwyxzABCDEFGHIJKLMNOPQRSTUVWYXZ1234567890";
					break;
					
					case '4':
						target_host.charset = "abcdefghijklmnopqrstuvwyxzABCDEFGHIJKLMNOPQRSTUVWYXZ1234567890!@#$%^&*()_-+=]}[{'\";:/?.>,<\\|";
					break;
				}
			break;
			
			case 'C':
				target_host.charset = alloc_copy(optarg);
			break;
			
			case 'm':
				target_host.min_chars = max(0, min(30, atoi(optarg)));
			break;
			
			case 'M':
				target_host.max_chars = max(0, min(30, atoi(optarg)));
			break;
			
			case 'h':
				host = alloc_copy(optarg);
			break;
			
			case 'H':
				host_file = alloc_copy(optarg);
			break;
			
			case 'e':
				port = max(0, atoi(optarg));
			break;
			
			case 'l':
				target_host.ssl = true;
			break;
			
			case 'v':
				mlevel += 1;
			break;
			
			case 't':
				p->set_threads(max(0, min(16384, atoi(optarg))));
			break;
			
			case 'T':
				p->set_conn_timeout(atoi(optarg));
			break;
			
			case 'n':
				target_host.passwd_options = 
			CServiceAttack::PasswdOptions(target_host.passwd_options | 
			CServiceAttack::PASSWD_OPTIONS_NULL);
			break;
			
			case 'y':
				target_host.passwd_options = 
			CServiceAttack::PasswdOptions(target_host.passwd_options | 
			CServiceAttack::PASSWD_OPTIONS_LOGIN);
			break;
			
			case 'r':
				target_host.passwd_options = 
			CServiceAttack::PasswdOptions(target_host.passwd_options | 
			CServiceAttack::PASSWD_OPTIONS_LOGIN_REV);
			break;
		}
	}
	p->set_output_level((CServiceAttack::MessageLevel) mlevel);
	p->set_output(print_data);
	p->set_notice(deal_with_results);
	
	if (!port) {
		switch (target_host.type) {
			case CServiceAttack::SERVICE_FTP:
				port = 21;
			break;
			
			case CServiceAttack::SERVICE_MYSQL:
				port = 3306;
			break;
			
			case CServiceAttack::SERVICE_POP3:
				if (!target_host.ssl)
					port = 110;
				else
					port = 995;
			break;
			
			case CServiceAttack::SERVICE_VNC:
			break;
		}
	}
	
	if (target_host.max_chars < target_host.min_chars) {
		target_host.max_chars = 30;
		printf("incorrect value of max-chars set\nsetting max-chars = 30\n");
	}
	
	if (passwd)
		p->set_passwd_func(get_single_passwd);
	else if (hFile)
		p->set_passwd_func(get_passwd);
	else if (target_host.charset) {
		if (!target_host.min_chars)
			target_host.min_chars = 1;
		if (!target_host.max_chars)
			target_host.max_chars = 8;
	} else if (target_host.max_chars < target_host.min_chars)
		return ( false );
	
	FILE *hHost = 0;
	bool bHost = true;
	if (target_host.type == CServiceAttack::SERVICE_NONE) {
		printf("no service selected - use the syntax '-s service' to select one\n");
		return ( false );
	}
	while (bHost) {
		if (host && port) {
			void *host_data = CServiceAttack::get_host_data(host, port);
			if (!host_data) {
				printf("unable to resolve hostname\n");
				return ( false );
			}
			
			memcpy(&target_host.addr, host_data,
			sizeof(target_host.addr));
			bHost = false;
		} else if (host_file) {
			hHost = fopen(host_file, "r");	
			if (!hHost) {
				printf("unable to open hostname file\n");
				return ( false );
			}
		}
		
		FILE *hUser = 0;
		if (user_file) {
			hUser = fopen(user_file, "r");
			if (!hUser) {
				printf("unable to open username file\n");
				return ( false );
			}
			
			if (hUser) {
				char *user_name = 0;
				while (user_name = CServiceAttack::get_next_line(hUser)) {
					target_host.user = user_name;
					p->add_target(target_host);
				}		
				fclose(hUser);
			}
		} else
			p->add_target(target_host);
	}
	
	if (!user_file)
		delete [] target_host.user;
	
	if (!target_host.charset)
		delete [] target_host.charset;
	
	return ( true );
}

void clean_up()
{
	if (passwd)
		delete [] passwd;
	if (hFile && hFile != stdin)
		fclose(hFile);
	if (crack)
		delete crack;
}

void print_usage()
{
	puts("chimera - remote passwd cracking tool v0.27");
	puts("(c) 2003,2004 by Lukasz Tomicki <tomicki@o2.pl>");
	puts(" usage: chimera [options]");
	puts(" options:");
	puts("  -s sets the service you want to attack to the given type");
	puts("     valid services are: ftp, pop3, mysql");
	puts("  -h host to attack");
	puts("  -H sets a file of hosts to attack");
	puts("  -e port to attack on the remote host (if not standard)");
	puts("  -u sets the user name for the service we are attacking");
	puts("  -U sets a file of user names to use");
	puts("  -p sets a passwd to check");
	puts("  -P sets a file of passwds to check (set 'stdin' to feed from");
	puts("     standard input");
	
	puts("  -n check for null passwords");
	puts("  -y check for passwodrs same as the user name");
	puts("  -r check for passwords same as the reversed user name");
	
	puts("  -c <n> use a brute force charset number <n> - for details refer");
	puts("     to the man pages");
	puts("  -C sets a user defined brute force charset");
	puts("  -m mininum number of characters to use (default: 1)");
	puts("  -M maximum number of characters to use (default: 8)");
	
	puts("  -l use ssl ( default: no )");
	puts("  -t number of threads to use (default: 256)");
	puts("  -T set connection timeout (default: 60)");
	puts("  -b number of microseconds between creating new threads (default: 250)");
	puts("  -a do not reduce thread number on connection errors (experts only)");
	puts("  -v verbose mode - use up to 5 times for more output");
}

int main(int argc, char **argv)
{	
	if (argc == 1) {
		print_usage();
		return 0;
	}
	
	crack = new CServiceAttack();
	
	if (parse_command_line_args(crack, argc,  argv))
		crack->run_atack();
	
	clean_up();
	
	return (0);
}
