/***************************************************************************
 *  CBrutePasswd.cc : This file is part of 'chimera'
 *
 *  (c) 2003,2004 by Lukasz Tomicki <tomicki@o2.pl>
 *	Documentation @ http://tomicki.net/
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "CBrutePasswd.h"
#include <stdio.h>

CBrutePasswd::CBrutePasswd():m_max_length(0), m_min_length(0), m_pos(0), m_next(0),
m_size(0)
{
	buffer = 0;
	m_charset = 0;
}

CBrutePasswd::CBrutePasswd(const char *charset):m_max_length(0),
m_min_length(0), m_pos(0), m_next(0), m_size(0)
{
	buffer = 0;
	m_charset = 0;
	setCharset(charset);
}

CBrutePasswd::~CBrutePasswd()
{
	if (buffer)
		delete [] buffer;
	freeCharset();
}

void CBrutePasswd::setCharset(const char *charset)
{
	freeCharset();
	m_charset = alloc_copy(charset);
	m_charset_size = strlen(m_charset);
}

void CBrutePasswd::freeCharset()
{
	if (m_charset) {
		delete[]m_charset;
		m_charset_size = 0;
	}
}

void CBrutePasswd::setMinLength(uint min_length)
{
	if (!min_length)
		min_length = 1;
/*
	//
	// revision 1.2 
	//
	
	uint min_val = passwd_max_size;

	m_min_length = max(m_min_leng6th, min_val);

	if (min_length > m_max_length)
		m_max_length = m_min_length;

	--m_min_length;
*/
}

void CBrutePasswd::setMaxLength(uint max_length)
{
	if (!max_length)
		max_length = 8;

	uint min_val = passwd_min_size;

	m_max_length = max(max_length, min_val);

	if (m_max_length < m_min_length)
		m_max_length = m_min_length;
}

void CBrutePasswd::rewindPasswds(uint min, uint max)
{
	setMinLength(min);
	setMaxLength(max);

	m_pos = m_max_length - 1;
	m_next = 0;
	m_size = 0;

	m_size = m_min_length;

	if (buffer)
		delete [] buffer;
	
	buffer = new char[m_max_length + 1];
	
	memset(buffer, m_max_length + 1, 0);
}

int CBrutePasswd::findCharPos(char c)
{
	for (uint i(0); i < m_charset_size; ++i)
		if (c == m_charset[i])
			return i;

	return -1;
}

const char *CBrutePasswd::getNextPasswd()
{
	pthread_mutex_t password_mutex = PTHREAD_MUTEX_INITIALIZER;
	pthread_mutex_lock(&password_mutex);
	
	if (!m_size)
		m_size = 1;

	if (m_next == m_charset_size) {
		char c;

		do {
			--m_pos;

			if (m_max_length - m_pos > m_size)
				++m_size;

			c = buffer[m_pos];
			if (c)
				c = findCharPos(c) + 1;

		} while (c == m_charset_size && m_pos >= 0);
		buffer[m_pos] = m_charset[c];
		++m_pos;
		m_next = 0;
		for (; m_pos < m_max_length; ++m_pos)
			buffer[m_pos] = m_charset[m_next];
		--m_pos;
	}

	if (m_size > m_max_length)
		return 0;

	buffer[m_pos] = m_charset[m_next];
	++m_next;
	
	pthread_mutex_unlock(&password_mutex);
	
	return (buffer + m_max_length - m_size);
}

double CBrutePasswd::getPasswdNum(uint max_length)
{
	uint max;

	if (max_length)
		max = max_length;
	else
		max = m_max_length;

	if (!max)
		return 0;

	uint size(strlen(m_charset));

	if (!size)
		return 0;

	double passwd_num(0);

	passwd_num = pow(size, max);
	if (m_min_length)
		passwd_num -= pow(size, m_min_length);

	return (passwd_num);
}
