/***************************************************************************
 *  misc.cc : This file is part of 'chimera'
 *
 *  (c) 2004 by Lukasz Tomicki <tomicki@o2.pl>
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */						
 
#include "misc.h"

char *alloc_copy(const char *str, uint extra)
{
	if (!str)
		return 0;

	uint size(strlen(str));

	if (!size)
		return 0;

	char *new_alloc = new char[size + 1 + extra];

	if (!new_alloc)
		return 0;

	memset(new_alloc, 0, size + 1 + extra);
	strncpy(new_alloc, str, size);

	return (new_alloc);
}
