/***************************************************************************
 *  service-ldap.cc : This file is part of 'chimera'
 *
 *  (c) 2004 by Lukasz Tomicki <tomicki@o2.pl>
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */																	

#include "CServiceAttack.h"

using namespace std;

int CServiceAttack::service_ldap(thread_data *pData)
{
	SOCKET sock = init_connection(pData);
	char buffer1[500];
	uint guess_n(1);
	bool passwd_used(true);
	while (pData->state == WORKING) {
		if (!sock) {
			sock = init_connection(pData);
			continue;
		}
		
		char buffer2[256];
		
		if (passwd_used) {
			if (!get_next_passwd(pData, buffer2, 256)) {
				pData->state = DONE;
				continue;
			}
			passwd_used = false;
		}
		
		u32 login_size = strlen(pData->user);
		u32 passwd_size = strlen(buffer2);
		u32 length = 14 + login_size + passwd_size;

	  	memset(buffer1, 0, sizeof(buffer1));
	  	buffer1[0] = 48;
	  	buffer1[1] = length - 2;
	  	buffer1[2] = 2;
	  	buffer1[3] = 1;
	  	buffer1[4] = guess_n % 256;
	  	buffer1[5] = 96;
	  	buffer1[6] = length - 7;
	  	buffer1[7] = 2;
	  	buffer1[8] = 1;
	  	buffer1[9] = 2;                /* version 2 */
	
	  	buffer1[10] = 4;
	  	buffer1[11] = login_size;   /* DN */
	  	memcpy(&buffer1[12], pData->user, login_size);
	
	  	buffer1[12 + login_size] = (u8) 128;
	  	buffer1[13 + login_size] = passwd_size;
	  	memcpy(&buffer1[14 + login_size], buffer2, passwd_size);      /* PASS */

 		sendAll(sock, pData->ssl, buffer1, strlen(buffer1), 0, std_timeout);
			
		if (!recvAll(sock, pData->ssl, buffer1, 256, 0, std_timeout)) {
			output(MSG_ERROR, "%s", buffer1);
			close(sock);
			adjust_connections(pData);
			return 0;
		}
		passwd_used = true;
		
		output(MSG_VERBOSE, "[%d] %s\n", guess_n, buffer2);
 		 /* success is: 0a 01 00 - failure is: 0a 01 31 */ // must check myself
		
  		if ((buffer2[0] != 0 && buffer2[9] == 0) || 
				(buffer2[0] != 32 && buffer2[9] == 32))
			account_cracked(pData, buffer2);
  	
	}
	close(sock);
	return 0;
}
