/***************************************************************************
 *  created on: Fri Apr 22 16:31:25 CDT 2005
 *
 *  (c) 2005 by Lukasz Tomicki <tomicki@o2.pl>
 * 
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <time.h>
#include <string.h>
#include <stdarg.h>

#include "log.h"

CLog::CLog(const char *path, bool append_mode)
{
	hFile = 0;
	logfile_path = path;

	if (!append_mode) {
		hFile = fopen(logfile_path, "w");
		Close();
	}
}

CLog::~CLog()
{
	Close();			
}

void CLog::Open()
{ 
	if (!hFile)
		hFile = fopen(logfile_path, "a");
};


void CLog::Close()
{ 
	if (hFile) {
		fflush(hFile);
		fclose(hFile);
		hFile = 0;
	}
}; 

void CLog::write(char *text,...)
{
	Open();
	if (!hFile)
		return;
	
	va_list arglist;
	char buffer[1024], buffer2[1024];
	memset(buffer, 0, sizeof(buffer));

	va_start(arglist, text);
	vsnprintf(buffer, 1024, text, arglist);
	va_end(arglist);
	const time_t s(time(0));
	struct tm *t= localtime(&s);
		
	snprintf(buffer2, 1024, "(%02d/%02d/%d %02d:%02d:%02d): %s\n", t->tm_mon, 
		t->tm_mday, 1900 + t->tm_year, t->tm_hour, t->tm_min, t->tm_sec, buffer);
	
	fprintf(hFile, buffer2);
	
	Close();
}
